<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categorias', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('tipo');
            $table->timestamps();
        });
    
        DB::table('categorias')->insert([
            [
                'nombre' => 'Servicio',
                'tipo' => 'producto',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre' => 'sencillo',
                'tipo' => 'varilla',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre' => 'premiun',
                'tipo' => 'trupan',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nombre' => 'durable',
                'tipo' => 'vidrio',
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categorias');
    }
};
